/*
 * RGBLED.c
 *
 * Created: 31.03.2013 10:22:43
 *  Author: Nenninger
 */ 
#define F_CPU 8000000UL

#define blau OCR0A
#define rot OCR1A
#define gruen OCR1B

#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>

#include <avr/io.h>

void waitms(int ms) {
	int i;
	for (i=0;i<ms;i++){
		_delay_ms(1);
	}
}

ISR(BADISR_vect){
	
}

void init(void){
	DDRA = 0xFF;
	DDRB = 0xFF;
	DDRD = 0xFF;
	//Eingnge definieren
	DDRD &= ~ ((1<<PD0) |(1<<PD1) | (1<<PD2) | (1<<PD3) | (1<<PD4) | (1<<PD5) | (1<<PD6));
	DDRA &= ~ ((1<<PA0) |(1<<PA1));
	
	//interne Pullups
	PORTD |= (1<<PD0) | (1<<PD1) | (1<<PD2) | (1<<PD3) | (1<<PD4) | (1<<PD5) | (1<<PD6);
	PORTA |= (1<<PA0) | (1<<PA1);
	
	//Ausgnge auf HI
	//PORTB |= (1 << PB0);
	//PORTB |= (1 << PB1);
	//PORTB |= (1 << PB2);
	//PORTB |= (1 << PB3);

	//Ausgnge auf LOW
	//PORTB &= ~(1 << PB4);
	//PORTB &= ~(1 << PB5);

	//ANA_COMP ausschalten;
	ACSR = (1<<ACD);
	// Into/Int1 abschalten
	GIMSK = 0x00;
	
	//PWM init Blau;
	TCCR0A = (1<<WGM10)|(1<<COM1A1);
	TCCR0B = (1<<CS10);
	OCR0A = 0;	//Geschwindigkeit
	
	//PWM init rot/Grn;
	TCCR1A = (1<<WGM11)|(1<<COM1A1)|(1<<COM1B1);
	TCCR1B = (1<<CS11);
	OCR1A = 1;	//Geschwindigkeit rot
	OCR1B = 0;	//Geschwindigkeit grn
	
}

int main(void)
{
	init();
	
    while(1)
    {
        if (( PIND & 64 ) == 64 ){
			if (!(( PIND & 1 ) == 1 )){if(rot<255){rot++;}}
			if (!(( PIND & 2 ) == 2 )){if(rot>0){rot--;}}
			if (!(( PIND & 4 ) == 4 )){if(gruen<255){gruen++;}}
			if (!(( PIND & 8 ) == 8 )){if(gruen>0){gruen--;}}
			if (!(( PIND & 16 ) == 16 )){if(blau<255){blau++;}}
			if (!(( PIND & 32 ) == 32 )){if(blau>0){blau--;}}
			waitms(10);
		}else{		
			if (!(( PIND & 1 ) == 1 )){rot=255;gruen=0;blau=0;}
			if (!(( PIND & 2 ) == 2 )){rot=255;gruen=150;blau=0;}
			if (!(( PIND & 4 ) == 4 )){rot=0;gruen=0;blau=255;}
			if (!(( PIND & 8 ) == 8 )){rot=0;gruen=255;blau=0;}
			if (!(( PIND & 16 ) == 16 )){rot=255;gruen=255;blau=50;}
			if (!(( PIND & 32 ) == 32 )){rot=255;gruen=255;blau=255;}
			if((PIND & 63) == 63 ){rot=0;gruen=0;blau=0;}
			waitms(30);
		}		
    }
}