/*
 * AVRGCC1.c
 *
 * Created: 19.02.2012 16:56:26
 *  Author: Nenninger
 */ 

#define F_CPU 7372800UL 

#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>

int mwait;
int waitA0;
int waitA1;

#define E0 1
#define E1 2
#define E2 4
#define E3 8
#define E4 16
#define E5 32
#define E6 64
#define E7 128

#define geh_enable()      ( PORTD |=  ( 1 << PD2 ) )
#define geh_disable()     ( PORTD &= ~( 1 << PD2 ) )

#define stand_enable()    ( PORTD |=  ( 1 << PD3 ) )
#define stand_disable()   ( PORTD &= ~( 1 << PD3 ) )

#define ledan()    ( PORTD |=  ( 1 << PD7 ) )
#define ledaus()   ( PORTD &= ~( 1 << PD7 ) )

#define BAUDAD 2400UL     // Baudrate
#define BAUDMaster 38400UL     // Baudrate

// Berechnungen Baudrate
#define UBRR_VAL ((F_CPU+BAUDAD*8)/(BAUDAD*16)-1)   // clever runden
#define BAUD_REAL (F_CPU/(16*(UBRR_VAL+1)))     // Reale Baudrate
#define BAUD_ERROR ((BAUD_REAL*1000)/BAUDAD) // Fehler in Promille, 1000 = kein Fehler.
 
#if ((BAUD_ERROR<990) || (BAUD_ERROR>1010))
  #error Systematischer Fehler der Baudrate nicht genau!!!! 
#endif 

#define UBRR_VALM ((F_CPU+BAUDMaster*8)/(BAUDMaster*16)-1)   // clever runden
#define BAUD_REALM (F_CPU/(16*(UBRR_VALM+1)))     // Reale Baudrate
#define BAUD_ERRORM ((BAUD_REALM*1000)/BAUDMaster) // Fehler in Promille, 1000 = kein Fehler.
 
#if ((BAUD_ERROR<990) || (BAUD_ERROR>1010))
  #error Systematischer Fehler der Baudrate nicht genau!!!! 
#endif 

//AD-Wandler
#define adcommaxlen 10 // Maximale Zeichen anzahl

volatile struct {
	unsigned fertig:1; //Daten empfangen (entweder maxstrlen oder Zeichen Timeout erreicht
	unsigned warte:1; // warte auf Zeichen
	unsigned anzahl:6; //Anzahl der Empfangenen Zeichen
       }
adcom;

char adcom_str[adcommaxlen]=""; //Empfangene Zeichen
char adcom_rcv[adcommaxlen]="";	//Empfangene Zeichen zum weiterarbeiten

volatile unsigned int adcom_rt; //Zhler Zeichen Timeout (RXD)

//UART0 (ADC) initialisieren
void adccom_init(void)
{
	UCSR0B = (1<<RXEN0)|(1<<RXCIE0);			// UART TX/RX RX Interruppt einschalten
	UCSR0C = (1<<URSEL0) | (1<<UCSZ01) | (1<<UCSZ00);	// Asynchron 8N1 
 
	UBRR0H = UBRR_VAL >> 8;
	UBRR0L = UBRR_VAL & 0xFF;
}



//UART1 (Master) initialisieren
void mcom_init(void)
{
	UCSR1B = (1<<TXEN1)|(1<<RXEN1)|(1<<RXCIE1);			// UART TX/RX RX Interruppt einschalten
	UCSR1C = (1<<URSEL1) | (1<<UCSZ11) | (1<<UCSZ10);	// Asynchron 8N1 
 
	UBRR1H = UBRR_VALM >> 8;
	UBRR1L = UBRR_VALM & 0xFF;
}

void mdowaitsendcomplet(void){
	//while (!(UCSR1A & (1<<TXC1))){}
	loop_until_bit_is_set(UCSR1A, TXC1);
	UCSR1A = (1<<TXC1);
	_delay_us(250);
	_delay_us(250);
	PORTB &= ~(1 << PB1); //schalte MAX485 auf empfangen
}


// sende ein Char zum Master
int msendc(char c)
{
    loop_until_bit_is_set(UCSR1A,UDRE1);	/* warten bis Senden moeglich */
    UDR1 = c;								/* sende Zeichen */
    return 0;
}

// dem Master einen ganzen String senden
void msend(char data[],unsigned char len)
{
	unsigned char count;
  
	PORTB |= (1 << PB1); //schalte MAX485 auf senden

	for (count = 0; count < len; count++)
	{
		msendc(data[count]);
	}

	mdowaitsendcomplet();
}

// dem Master ein Char senden
void msendnc(char data)
{
  
	PORTB |= (1 << PB1); //schalte MAX485 auf senden

	msendc(data);

	mdowaitsendcomplet();
}

//Timer0
ISR (TIMER0_COMP_vect)
{
	if(adcom.warte == 1){	//warte auf Zeichen
		adcom_rt++;			//dann Zhler Timeout Zeichen +1
	}

	if(adcom_rt == 20){		//Timeout Zeichen (RXD) dann String zum weiterverarbeiten geben
		adcom.warte = 0;
		adcom_rt = 0;
		adcom.fertig=1;
	}
	mwait++;				//Zhler kein Zeichen vom Display (wird im Quelltext manchmal auf 0 gesetzt)
	/*if(mwait==500){
		mwait=0;
		if (OCR1B<254){
	    OCR1B =	OCR1B++;
		}else{
			OCR1B=0;
		}
		if (OCR3B<254){
	    OCR3B =	OCR3B++;
		}else{
			OCR3B=0;
		}
	}*/			
	/*if(mwait==1000){
		PORTD |= (1 << PD7);
		PORTB |= (1 << PB1);
		PORTE |= (1 << PE0);
		PORTE |= (1 << PE1);
		PORTD |= (1 << PD6);
		PORTD |= (1 << PD2);
		PORTD |= (1 << PD3);
	}
	if(mwait==2000){
		
		PORTD &= ~(1 << PD7);
		PORTB &= ~(1 << PB1);
		PORTE &= ~(1 << PE0);
		PORTE &= ~(1 << PE1);
		PORTD &= ~(1 << PD6);
		PORTD &= ~(1 << PD2);
		PORTD &= ~(1 << PD3);
		mwait = 0;
	}*/
	if(waitA0 > 0){
		waitA0--;
	}
	if(waitA1 > 0){
		waitA1--;
	}
}

ISR(BADISR_vect)
{
    ledan();
	
}
	

//Zeichen vom ADC Empfangen
ISR(USART0_RXC_vect)
{
	unsigned char buffer;
    adcom_rt = 0;
	adcom.warte = 1;
	buffer = UDR0;							// Daten aus dem Puffer lesen
	if ( adcom.fertig==0 ){					// wenn  gerade nicht in Verarbeitung
		if (adcom.anzahl < adcommaxlen-1){	// wenn nicht maximal Anzahl
			adcom_str[adcom.anzahl]=buffer;	// Zeichen an den String anhngen
			adcom.anzahl++;					// Anzahl der Zeichen + 1
		} else {
			adcom_str[adcom.anzahl]=buffer;
			//dcom.anzahl=0;
			adcom.fertig=1;
			adcom.warte = 0;
		}
	}
}


//erstmal alles in was definiertes bringen
void init(void) {
	
	/* Beschreibung der ein und Ausgnge
	PA0	-< Geh ist auf 
	PA1 -< Geh ist zu
	PA2 -< Stand ist auf
	PA3 -< Stand ist zu
	PA4 -< 
	PA5 -< 
	PA6 -< 
	PA7 -< 
	
	PC0	-< AUF
	PC1 -< ZU
	PC2 -< STOP
	PC3 -< Geh
	PC4 -< Geh+Garage
	PC5 -< LS
	PC6 -< am Tor AUF
	PC7 -< am Tor ZU
	
	
	PB0= -> Clock Attiny13 (AD-Wandler)
	PB1= Master RS485 (enable)
	PB2= Master RS485
	PB3= Master RS485
	PB4= -> PWM Stand zu
	
	PB5-7 ISP

	PD0=AD-Wandler RX
	PD1=AD-Wandler TX
	PD2= -> Geh Enabled
	PD3= -> Stand Enabled 

	PD4= -> PWM Stand auf
	PD5= -> PWM Geh auf
	PD6= -> LED's
	PD7= -> rote LED Master Offline
	
	PE0= -> Garage auf
	PE1= -> Netzteil ein
	PE2= -> PWM Geh zu	

	*/

	//Alles als Eingnge definieren
	DDRA = 0x00;
	DDRB = 0x00;
	DDRC = 0x00;
	DDRD = 0x00;
	DDRE = 0x00;
	
	//Ausgnge
	DDRB |= (1<<PB1)|(1<<PB4);
	DDRD |= (1<<PD2)|(1<<PD3)|(1<<PD4)|(1<<PD5)|(1<<PD6)|(1<<PD7);
	DDRE |= (1<<PE0)|(1<<PE1)|(1<<PE2);

	//interne Pullups
	PORTA = 0xff;
	PORTC = 0xff;
	//PORTD |= (1<<PD0) | (1<<PD1) | (1<<PD2);
	//PORTE |= (1<<PE0) | (1<<PE1) | (1<<PE2);

	//Ausgnge auf HI
	//PORTB |= (1 << PB2);

	//ANA_COMP ausschalten;
	ACSR = (1<<ACD);
	
	//dcom_init();
	//mcom_init();

	// Timer 0 konfigurieren
    TCCR0 |= (1<<CS00) | (1<<CS01) | (1<<WGM01); // Prescaler 64 CTC
	OCR0 = 0x72; // ca 1ms
    
	// Compare Interrupt erlauben
	TIMSK |= (1<<OCIE0);
	

	//PWM init Geh;
	TCCR1B |= (1<<CS11); //Prescaler 8
	TCCR1A |= (1<<WGM10);
	TCCR1B |= (1<<WGM12);
	TCCR1A |= (1<<COM1A1) | (1<<COM1B1) ;	
	OCR1A =	0;
	OCR1B = 0;
	//PWM init Stand
	TCCR3B |= (1<<CS31); //Prescaler 8
	TCCR3A |= (1<<WGM30);
	TCCR3B |= (1<<WGM32);
	TCCR3A |= (1<<COM3A1) | (1<<COM3B1) ;	
	OCR3A =	0;
	OCR3B = 0;

	//ms = 0;

	//step.geh = 0;
	//step.stand = 0;
	mcom_init();
	adccom_init();
	sei();
	//PORTD |= (1<<PD2) | (1<<PD3);
	waitA0=0;
	waitA1=0;
}

void waitms(int ms) {	//mehr warte ;-)
	int i;
 	for (i=0;i<ms;i++){
		_delay_ms(1);
	}
}

int main(void)
{
    init();
	//stand_enable();
	//OCR3A = 254;
	while(1)
    {
       if(adcom.fertig==1){				//Daten vom AD-Wandler?
			unsigned char len;
			uint16_t adc1;
			uint16_t adc2;
			//var = ((HByte << 8 ) | LByte);
			len = adcom.anzahl;
			adcom.anzahl = 0;
			memcpy(adcom_rcv,adcom_str,len);	//Daten zum weiterarbeiten kopieren
			if((adcom_rcv[0]=='[') & (adcom_rcv[5]==']')){
				adc2 = ((adcom_rcv[2] << 8 ) | adcom_rcv[1]);
				adc1 = ((adcom_rcv[4] << 8 ) | adcom_rcv[3]);
				adcom.fertig=0;
				char cmd[4];
				char cmd2[4];
				utoa( adc1, cmd, 10 ); 
				msend(cmd,4);
				utoa( adc2, cmd2, 10 ); 
				msend(cmd2,4);
				cmd[0]=PINA;
				cmd[1]=PINC;
				msend(cmd,2);
			
			}
	   }
	   if ((!(( PINA & E0 ) == E0 ))&(waitA0==0)) {
		   waitA0 = 1000;
			geh_enable();
			OCR1A=254;
			
	   }
	   if (((( PINA & E0 ) == E0 ))&(waitA0==0)) {
		   waitA0 = 1000;
		    geh_disable();
			OCR1A=0;
	   }
	   if ((!(( PINA & E1 ) == E1 ))&(waitA1==0)) {	
		   waitA1 = 1000;
			stand_enable();
			OCR3A=254;
			
	   }
	   if (((( PINA & E1 ) == E1 ))&(waitA1==0)) {
		   waitA1 = 1000;	
		    stand_disable();
			OCR3A=0;
	   }				   				
			
		
    }
	return 0;
}