//Master
#include <avr/interrupt.h>
#include <string.h>
#include <avr/pgmspace.h>
#include <stdio.h>
#include <stdlib.h>

#include "config.h"
#include "usart.h"
#include "rs485.h"
//#include "telnetd.h"



void initti (void)
{
// Timer 0 konfigurieren
    //TCCR0A |= (1<<CS00) | (1<<CS01) | (1<<WGM01); // Prescaler 64 CTC
	//OCR0A = 0xF9; // Vergleicher 114 weil 7372800/64 = 115200 
	TCCR0B |= (1<<WGM02) | (1<<CS00 | 1<<CS01 | 0<<CS02);
	TCNT0 = 0;
	OCR0A = 0xF9;
	// Compare Interrupt erlauben
	TIMSK0 |= (1<<OCIE0A);
	sensor.helligkeit = 20;
}
	
ISR (TIMER0_COMPA_vect)
{
	if((rs485_timer   > 0)&(m_status.poll==1)){
		rs485_timer--;
	}
	
	if(mcom.warte == 1){	//warte auf Zeichen
		mcom_rt++;			//dann Zhler Timeout Zeichen +1
	}

	if(mcom_rt == 20){		//Timeout Zeichen (RXD) dann String zum weiterverarbeiten geben
		mcom.warte = 0;
		mcom_rt = 0;
		mcom.fertig=1;
	}
	
	mwait++;				//Zhler kein Zeichen vom Gert
	if(mwait==1000){
		mwait = 0;
		m_status.poll = 1;
		cbi(devonline,devadr);
	}
	
	msekunden++;
	if(msekunden==1000){
		msekunden=0;
		sekunden++;
	}
	if(sekunden==60){
		sekunden=0;
		minuten++;
		//innen Licht runterzhlen
		if(ilichtzeit>0){
			if((PINC & 0x0F) == 0x0F){
				ilichtzeit--;
			}else{
				ilichtzeit=ILICHTMAX;
			}
		}
	}
	if(minuten==60){
		minuten=0;
		
	}
	
}

void seg(unsigned char x,unsigned char y){
	sendegpos++;
	sendeg[sendegpos-1]=x;
	sendegpos++;
	sendeg[sendegpos-1]=y;
	return;
}
void sog(unsigned char x,unsigned char y){
	sendogpos++;
	sendog[sendogpos-1]=x;
	sendogpos++;
	sendog[sendogpos-1]=y;
	return;
}
void ssm1(unsigned char x,unsigned char y){
	sendsm1pos++;
	sendsm1[sendsm1pos-1]=x;
	sendsm1pos++;
	sendsm1[sendsm1pos-1]=y;
	return;
}
void stor(unsigned char x){
	sendtorpos=1;
	sendtor[0]=x;
	return;
}
//Umsetzung Steuerbefehl von Webseite oder Telnet
void steuerung(unsigned char x){
	switch (x){
		//EG 
		case ('A'):		//AZ rauf
			seg(0,1); 
		break;
		case ('B'):		//AZ runter
			seg(0,2);
		break;
				
		case ('C'):
			seg(1,1);
		break;
 
		case ('D'):
			seg(1,2);
		break;
 
		case ('E'):
			seg(2,1);
		break;
 
		case ('F'):
			seg(2,2);
		break;
  
		case ('G'):
			seg(3,1);
		break;
  
		case ('H'):
			seg(3,2);
		break;

		case ('I'):
			seg(4,1);
		break;
 
		case ('J'):
			seg(4,2);
		break;

		case ('K'):
			seg(5,1);
		break;
 
		case ('L'):
			seg(5,2);
		break;

		case ('M'):
			seg(6,1);
		break;

		case ('N'):
			seg(6,2);
		break;

		case ('Q'):
			seg(200,1);
		break;

		case ('R'):
			seg(200,2);
		break;
 
		case ('S'):
			seg(201,1);
		break;
 
		case ('V'):
			seg(200,3);
		break;

		//Aussenlicht LED
		case ('W'):
			PORTD |= (1 << PD3);
		break;
		case ('X'):
			PORTD &= ~(1 << PD3);
		break;
		
		//Aussenlicht Scheinwerfer
		case ('O'):		//an
			seg(7,1);
			ssm1(4,1);
		break;			//aus
		case ('P'):
			seg(7,3);
			ssm1(4,2);
		break;
	
		//Innenlicht
		case ('Y'):
			PORTD |= (1 << PD4);
		break;
		case ('Z'):
			PORTD &= ~(1 << PD4);
		break;
		
		//Tor
		case ('1'):		//AUF
			stor(1);
		break;
		case ('2'):		//ZU
			stor(2);
		break;
		case ('3'):		//Geh
			stor(3);
		break;
		case ('4'):		//STOP
			stor(4);
		break;
		
		//Schaltmodul Garage
		case ('5'):
			ssm1(1,1);
		break;
		case ('6'):
			ssm1(1,2);
		break;
		case ('7'):
			ssm1(2,1);
		break;
		case ('8'):
			ssm1(2,2);
		break;
		case ('9'):
			ssm1(3,1);
		break;
		case ('0'):
			ssm1(3,2);
		break;
		
		//OG
		case ('a'):		//SZ hoch
			sog(0,1);
		break;
	
		case ('b'):		//SZ runter
			sog(0,2);
		break;

		case ('c'):		//WZ Strasse hoch
			sog(1,1);
		break;
 
		case ('d'):
			sog(1,2);
		break;

		case ('e'):
			sog(2,1);
		break;
 
		case ('f'):
			sog(2,2);
		break;

		case ('g'):
			sog(3,1);
		break;
 
		case ('h'):
			sog(3,2);
		break;

		case ('i'):
			sog(4,1);
		break;
 
		case ('j'):
			sog(4,2);
		break;

		case ('k'):
			sog(5,1);
		break;
 
		case ('l'):
			sog(5,2);
		break;
 
		case ('m'):
			sog(6,1);
		break;
 
		case ('n'):
			sog(6,2);
		break;

		case ('o'):
			sog(7,1);
		break;

		case ('p'):
			sog(7,2);
		break;

		case ('q'):		//Alle Rolllden hoch
			sog(200,1);
		break;

		case ('r'):		//Alle Rolllden runter
			sog(200,2);
		break;

		case ('s'):		//Sonnenschutz
			sog(201,1);
		break;

		case ('t'):		//Alle Zipscreen hoch
			sog(4,1);
			sog(5,1);
			sog(6,1);
			sog(7,1);
		break;
	
		case ('u'):		//Alle Zipscreen runter
			sog(4,2);
			sog(5,2);
			sog(6,2);
			sog(7,2);
		break;
	
		case ('v'):		//ALLE Rolllden Stop
			sog(200,3);
		break;
		
		case ('w'):		//ALLE Rolllden Stop
			sog(4,3);
			sog(5,3);
			sog(6,3);
			sog(7,3);
		break;

	}
}

void dopoll (void)
{
	if(mcom.fertig==1){				//Daten vom Master?
		unsigned char len;
		m_status.poll = 0;
		len = mbuffercounter;
		mbuffercounter = 0;
		mcom.fertig=0;
		if(m_rx_buffer[0]==0xfe){
			if(m_rx_buffer[1]==devadr){
				sbi(devonline,devadr);
			}
			if(m_rx_buffer[1]==0){
				eg.funktion0 = m_rx_buffer[2];
				eg.funktion1 = m_rx_buffer[3];
				eg.funktion2 = m_rx_buffer[4];
				eg.funktion3 = m_rx_buffer[5];
				eg.funktion4 = m_rx_buffer[6];
				eg.funktion5 = m_rx_buffer[7];
				eg.funktion6 = m_rx_buffer[8];
				eg.funktion7 = m_rx_buffer[9];
				eg.helligkeit_ist = m_rx_buffer[10];
				eg.urlaub = m_rx_buffer[11];
				eg.helligkeit_soll = m_rx_buffer[12];
				eg.helligkeit_sonne = m_rx_buffer[13];
				eg.temperatur_ist = m_rx_buffer[14];
				eg.automatik = m_rx_buffer[15];
			}
			if(m_rx_buffer[1]==1){
				og.funktion0 = m_rx_buffer[2];
				og.funktion1 = m_rx_buffer[3];
				og.funktion2 = m_rx_buffer[4];
				og.funktion3 = m_rx_buffer[5];
				og.funktion4 = m_rx_buffer[6];
				og.funktion5 = m_rx_buffer[7];
				og.funktion6 = m_rx_buffer[8];
				og.funktion7 = m_rx_buffer[9];
				og.helligkeit_ist = m_rx_buffer[10];
				og.urlaub = m_rx_buffer[11];
				og.helligkeit_soll = m_rx_buffer[12];
				og.helligkeit_sonne = m_rx_buffer[13];
				og.temperatur_ist = m_rx_buffer[14];
				og.automatik = m_rx_buffer[15];
			}
			if(m_rx_buffer[1]==2){
				sensor.helligkeit = m_rx_buffer[2];
				sensor.temperatur = m_rx_buffer[3];
				sensor.eingaenge = m_rx_buffer[6];
			}
			if(m_rx_buffer[1]==3){
				tor.ls = m_rx_buffer[2];
				tor.geh = m_rx_buffer[3];
				tor.stand = m_rx_buffer[4];
				tor.steuerung = m_rx_buffer[5];
			}
			if(m_rx_buffer[1]==5){//sm1 Garage
				sm1.ausgang = m_rx_buffer[2];
			}
		}
		rs485_timer = polltime;
		m_status.poll = 1;
	}
	char cmd[33];
	char slen;
	
	if(!rs485_timer){
		m_status.poll = 0;
		rs485_timer = polltime;
		if(devadr < maxdevadr){
			devadr++;
		}else{
			devadr = 0;
		}
		if(devadr==4){
			cmd[0] = 0xfe;
			cmd[1] = 4;
			cmd[2] = PINC ^ 0xff;
			cmd[3] = '*';
			usart_write_s(cmd,4);
			m_status.poll = 1;
		}else{
			cmd[0] = 0xff;
			cmd[1] = devadr;
			slen = 2;
			if((devadr==0)&(sendegpos>0)){
				unsigned char c;
				for(c=0;c<sendegpos+1;c++){
					cmd[c+2] = sendeg[c];
					
				}
				slen = sendegpos+2;
				sendegpos=0;
                //telnet_write("Befehl EG\r\n");
			
			}
			if((devadr==1)&(sendogpos>0)){
				unsigned char c;
				for(c=0;c<sendogpos+1;c++){
					cmd[c+2] = sendog[c];
					
				}
				slen = sendogpos+2;
				sendogpos=0;
                //telnet_write("Befehl OG\r\n");
			
			}
			if((devadr==3)&(sendtorpos>0)){
				cmd[2] = sendtor[0];
				slen = 1+2;
				sendtorpos=0;
                //telnet_write("Befehl Tor\r\n");
			
			}
			if((devadr==5)&(sendsm1pos>0)){
				unsigned char c;
				for(c=0;c<sendsm1pos+1;c++){
					cmd[c+2] = sendsm1[c];
					
				}
				slen = sendsm1pos+2;
				sendsm1pos=0;
                //telnet_write("Befehl SM1\r\n");
			
			}
			usart_write_s(cmd,slen);
			
			
		}
	}
}