/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        24.10.2007
 Description:    Webserver uvm.

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
----------------------------------------------------------------------------*/

#include <avr/io.h>
#include "config.h"
#include "usart.h"
#include "networkcard/enc28j60.h"
#include "stack.h"
#include "timer.h"
#include "httpd.h"
//#include "cmd.h"
//#include "telnetd.h"
#include "ntp.h"
#include "base64.h"
//#include "analog.h"
#include "sendmail.h"
#include <avr/eeprom.h>
#include "rs485.h"



//----------------------------------------------------------------------------
//Hier startet das Hauptprogramm
int main(void)
{  
	//Konfiguration der Ausgnge bzw. Eingnge
	//definition erfolgt in der config.h
	DDRA = OUTA;
	DDRC = OUTC;
	DDRD = OUTD;
	
	PORTD &= ~(1 << PD2); //schalte MAX485 auf empfangen
	
	PORTC = 0xFF;
	PORTA = 0x0F;

	
    unsigned long a;

	
    usart_init(BAUDRATE); // setup the UART
	
	#if USE_ADC
		ADC_Init();
	#endif
	
	//usart_write("\n\rSystem Ready\n\r");
    //usart_write("Compiliert am "__DATE__" um "__TIME__"\r\n");
    //usart_write("Compiliert mit GCC Version "__VERSION__"\r\n");

	for(a=0;a<1000000;a++){asm("nop");};

	//Applikationen starten
	stack_init();
	httpd_init();
	//telnetd_init();
	
	//Ethernetcard Interrupt enable
	ETH_INT_ENABLE;
	
	//Globale Interrupts einschalten
	sei(); 
	
	
	

	#if USE_NTP
		ntp_init(); 
	   
		for(a=0;a<1000000;a++){asm("nop");};
	   
		ntp_request();
	   
		if ( ntp() != 0 )
		{
		  //telnet_write("NTP Err.\r\n");
		}
		else
		{
		  //command_time();
		}
	#endif //USE_NTP
	
	
	
	m_status.poll = 1;
	mcom.fertig = 0;
	maxdevadr=5;
	devadr=maxdevadr;
	sendegpos=0;
	sendogpos=0;
	sendsm1pos=0;
	msekunden=0;
	sekunden=0;
	minuten=0;
	ilichtzeit=0;
	
	volatile struct {
		unsigned aussen:2;
		unsigned innen:2;
	}
	sensorfkt;
	
	sensorfkt.aussen = 0;
	sensorfkt.innen = 0;
	
	initti();
	
	//mail_enable = 1;
	
	while(1)
	{
		#if USE_ADC
		ANALOG_ON;
		#endif
	    eth_get_data();
		
        //Terminalcommandos auswerten
		/*if (telnet_status.telnet_ready){
            //telnet_write("\r\n");
			switch(telnet_rx_buffer[0]-48){
				case 0:
					seg((telnet_rx_buffer[1]-48),(telnet_rx_buffer[2]-48));
				break;
				case 1:
					sog((telnet_rx_buffer[1]-48),(telnet_rx_buffer[2]-48));
				break;
				case 3:
					stor((telnet_rx_buffer[1]-48));
				break;
				case 5:
					ssm1((telnet_rx_buffer[1]-48),(telnet_rx_buffer[2]-48));
				break;
			}
			telnet_status.telnet_ready =0;
		}*/
        
        //Empfang von Zeitinformationen
		#if USE_NTP
		if(!ntp_timer){
			ntp_timer = NTP_REFRESH;
			ntp_request();
		}
		#endif //USE_NTP
		
        //Versand von E-Mails
        #if USE_MAIL
        if (mail_enable == 1)
        {
            mail_enable = 0;
            mail_send();
        }
        #endif //USE_MAIL
  
		//USART Daten fr Telnetanwendung?
		//telnetd_send_data();
        
        if(ping.result)
        {
            //usart_write("Get PONG: %i.%i.%i.%i\r\n",ping.ip1[0],ping.ip1[1],ping.ip1[2],ping.ip1[3]); 
            ping.result = 0;
        }
		
		if((sensor.helligkeit>1)&((sensorfkt.aussen==0)|(sensorfkt.aussen==2))){//Aussen ausschalten
			PORTD &= ~(1 << PD3);
			sensorfkt.aussen=1;
		}
		if((sensor.helligkeit<1)&((sensorfkt.aussen==0)|(sensorfkt.aussen==1))){//Aussen einschalten
			PORTD |= (1 << PD3);
			sensorfkt.aussen=2;
		}
		
		if((sensor.helligkeit>22)&((sensorfkt.innen==0)|(sensorfkt.innen==2))){//Innen ausschalten
			PORTD &= ~(1 << PD4);
			sensorfkt.innen=1;
		}
		if((sensor.helligkeit<20)&((sensorfkt.innen==0)|(sensorfkt.innen==1))){//Innen einschalten
			
			if((PINC & 0x0F) == 0x0F){//wenn alle Tren(1-4) zu
				
			}else{//sonst an
			    ilichtzeit=ILICHTMAX;
				PORTD |= (1 << PD4);
				sensorfkt.innen=2;
			}
		}
		
		if((ilichtzeit==0)&(sensorfkt.innen==2)){//wenn Licht Zeit abgelaufen, dann Aus
			PORTD &= ~(1 << PD4);
			sensorfkt.innen=1;
		}
		
		if(sensor.eingaenge & (1<<0)){
			PORTA |= (1 << PA3);
		}else{
			PORTA &= ~(1 << PA3);
		}
		
		dopoll();
    }//while (1)
		
return(0);
}

