/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        24.10.2007
 Description:    Webserver Applikation

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
------------------------------------------------------------------------------*/
#include "config.h"
#include "telnetd.h"
#include "stack.h"

#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <string.h>
#include <avr/io.h>

char *retransmission_pointer;

//alte Uart_c
volatile unsigned int buffercounter = 0;

char telnet_rx_buffer[BUFFER_SIZE];
char *rx_buffer_pointer_in	= &telnet_rx_buffer[0];
char *rx_buffer_pointer_out	= &telnet_rx_buffer[0];
	

//----------------------------------------------------------------------------
//Routine fr die Serielle Ausgabe eines Zeichens (Schnittstelle0)
void telnet_write_char(char c)
{
	
	if(rx_buffer_pointer_in == (rx_buffer_pointer_out - 1))
	{
		//Datenverlust
				telnetd_send_data ();
				while(telnetd_status.ack_wait)
				{
					eth_get_data();
				}
	}

	*rx_buffer_pointer_in++ = c;

	if (rx_buffer_pointer_in == &telnet_rx_buffer[BUFFER_SIZE-1])
	{
		rx_buffer_pointer_in = &telnet_rx_buffer[0];
	}
	return;
}

//------------------------------------------------------------------------------
void telnet_write_P (const char *Buffer,...)
{
	va_list ap;
	va_start (ap, Buffer);	
	
	int format_flag;
	char str_buffer[10];
	char str_null_buffer[10];
	char move = 0;
	char Base = 0;
	int tmp = 0;
	char by;
	char *ptr;
		
	//Ausgabe der Zeichen
    for(;;)
	{
		by = pgm_read_byte(Buffer++);
		if(by==0) break; // end of format string
            
		if (by == '%')
		{
            by = pgm_read_byte(Buffer++);
			if (isdigit(by)>0)
				{
                                 
 				str_null_buffer[0] = by;
				str_null_buffer[1] = '\0';
				move = atoi(str_null_buffer);
                by = pgm_read_byte(Buffer++);
				}

			switch (by)
				{
                case 's':
                    ptr = va_arg(ap,char *);
                    while(*ptr) { telnet_write_char(*ptr++); }
                    break;
				case 'b':
					Base = 2;
					goto ConversionLoop;
				case 'c':
					//Int to char
					format_flag = va_arg(ap,int);
					telnet_write_char (format_flag++);
					break;
				case 'i':
					Base = 10;
					goto ConversionLoop;
				case 'o':
					Base = 8;
					goto ConversionLoop;
				case 'x':
					Base = 16;
					//****************************
					ConversionLoop:
					//****************************
					itoa(va_arg(ap,int),str_buffer,Base);
					int b=0;
					while (str_buffer[b++] != 0){};
					b--;
					if (b<move)
						{
						move -=b;
						for (tmp = 0;tmp<move;tmp++)
							{
							str_null_buffer[tmp] = '0';
							}
						//tmp ++;
						str_null_buffer[tmp] = '\0';
						strcat(str_null_buffer,str_buffer);
						strcpy(str_buffer,str_null_buffer);
						}
					telnet_write_str (str_buffer);
					move =0;
					break;
				}
			
			}	
		else
		{
			telnet_write_char ( by );	
		}
	}
	va_end(ap);
}

//----------------------------------------------------------------------------
//Ausgabe eines Strings
void telnet_write_str(char *str)
{
	while (*str)
	{
		telnet_write_char(*str++);
	}
}

//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
//Initialisierung des telnetd Testservers
void telnetd_init (void)
{
	//Serverport und Anwendung in TCP Anwendungsliste eintragen
	add_tcp_app (TELNET_APP_PORT, (void(*)(unsigned char))telnetd);
}

//----------------------------------------------------------------------------
//telnet Testserver
void telnetd (unsigned char index)
{
	//Verbindung wurde abgebaut!
    if (tcp_entry[index].status & FIN_FLAG)
    {
        telnet_status.telnet_disable = 0;
        return;
    }
    
	if (tcp_entry[index].app_status == 0 || tcp_entry[index].app_status == 1)
	{
		tcp_entry[index].app_status = 1; 
		memcpy_P(&eth_buffer[TCP_DATA_START],PSTR("OK\r\n"),4);
		create_new_tcp_packet(2,index);
		telnet_status.telnet_disable = 1;
		telnetd_status.ack_wait = 0;
		tcp_entry[index].time = TCP_TIME_OFF;
		return;
	}	

	if ((tcp_entry[index].app_status > 1) && (tcp_entry[index].status&PSH_FLAG))
	{
		tcp_entry[index].app_status = 2;	
		for (int a = TCP_DATA_START_VAR;a<(TCP_DATA_END_VAR);a++)
		{
                unsigned char receive_char;
                receive_char = eth_buffer[a];
        
                if (receive_char == 0x08)
                {
                    if (buffercounter) buffercounter--;
                }
                else if (receive_char == '\r' && (!(telnet_rx_buffer[buffercounter-1] == '\\')))
                {
                    telnet_rx_buffer[buffercounter] = 0;
                    buffercounter = 0;
                    telnet_status.telnet_ready = 1;
                    break;    
                }
                else if (buffercounter < BUFFER_SIZE - 1)
                {
                    telnet_rx_buffer[buffercounter++] = receive_char;    
                }
		}
		tcp_entry[index].status =  ACK_FLAG;
		create_new_tcp_packet(0,index);
		return;
	}
	
	//Ack erhalten vom gesendeten Packet
	if ((tcp_entry[index].app_status > 1)&&(tcp_entry[index].status&ACK_FLAG)&&(telnetd_status.ack_wait))
	{
		tcp_entry[index].time = TCP_TIME_OFF;
		rx_buffer_pointer_out = retransmission_pointer;
		telnetd_status.ack_wait = 0;
		return;
	}
	
	//Time out kein ack angekommen
	if (tcp_entry[index].status == 0) 
	{
		//Daten nochmal senden
		telnetd_status.ack_wait = 0;
		telnetd_send_data ();
		return;
	}
	
	return;
}

//----------------------------------------------------------------------------
//telnet Testserver
void telnetd_send_data (void)
{
	unsigned char index;
	if (rx_buffer_pointer_in != retransmission_pointer)
	{
		for (index = 0;index<MAX_TCP_ENTRY;index++)
		{
			if(tcp_entry[index].dest_port == HTONS(23))
			{
				if(!telnetd_status.ack_wait)
					{
					telnetd_status.ack_wait = 1;
					unsigned int count = 0;
					retransmission_pointer = rx_buffer_pointer_out; 
					
					while(rx_buffer_pointer_in != retransmission_pointer)
					{
						eth_buffer[TCP_DATA_START+count] = *retransmission_pointer++;
						count++;
						if (retransmission_pointer == &telnet_rx_buffer[BUFFER_SIZE-1])
						{
							retransmission_pointer = &telnet_rx_buffer[0];
						}
					}
					tcp_entry[index].status =  ACK_FLAG | PSH_FLAG;
					create_new_tcp_packet(count,index);
					tcp_entry[index].time = TCP_MAX_ENTRY_TIME;
					return;
				}
				else
				{
				return;
				}
			}
		}
		if (index >= MAX_TCP_ENTRY)
		{
			if(telnet_status.telnet_disable)
			{
				telnet_status.telnet_disable = 0;
			}
		}
	}
}






